/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.block;

import com.tfar.metalbarrels.tile.MetalBarrelBlockEntity;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class MetalBarrelBlock
extends BarrelBlock {
    protected final BlockEntityType.BlockEntitySupplier<BlockEntity> tileEntitySupplier;

    public MetalBarrelBlock(BlockBehaviour.Properties properties, BlockEntityType.BlockEntitySupplier<BlockEntity> tileEntitySupplier) {
        super(properties);
        this.tileEntitySupplier = tileEntitySupplier;
    }

    public void m_6810_(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof MetalBarrelBlockEntity) {
                MetalBarrelBlock.dropItems((MetalBarrelBlockEntity)tileentity, worldIn, pos);
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public static void dropItems(MetalBarrelBlockEntity barrel, Level world, BlockPos pos) {
        IntStream.range(0, barrel.handler.getSlots()).mapToObj(arg_0 -> ((ItemStackHandler)barrel.handler).getStackInSlot(arg_0)).filter(stack -> !stack.m_41619_()).forEach(stack -> Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!world.f_46443_) {
            MenuProvider tileEntity = this.m_7246_(state, world, pos);
            if (tileEntity != null) {
                MetalBarrelBlockEntity metalBarrelBlockEntity = (MetalBarrelBlockEntity)tileEntity;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(true)), 3);
                if (metalBarrelBlockEntity.players == 0) {
                    metalBarrelBlockEntity.soundStuff(state, SoundEvents.f_11725_);
                    metalBarrelBlockEntity.changeState(state, true);
                }
                ++metalBarrelBlockEntity.players;
                player.m_5893_(tileEntity);
                player.m_36220_(Stats.f_12971_);
                PiglinAi.m_34873_((Player)player, (boolean)true);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.tileEntitySupplier.m_155267_(pos, state);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity barrel = world.m_7702_(pos);
        return barrel instanceof MetalBarrelBlockEntity ? ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)((MetalBarrelBlockEntity)barrel).handler) : 0;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockentity;
        if (pStack.m_41788_() && (blockentity = pLevel.m_7702_(pPos)) instanceof MetalBarrelBlockEntity) {
            MetalBarrelBlockEntity metalBarrelBlock = (MetalBarrelBlockEntity)blockentity;
            metalBarrelBlock.setCustomName(pStack.m_41786_());
        }
    }
}

